unit uWeryfikatorKartKredytowych;

interface

uses
  SysUtils;

type
  IWeryfikatorKartKredytowych = interface(IInvokable)
    ['{68553321-248C-4FD4-9881-C6B6B92B95AD}']
    function CzyKartaJestWana(aNumerKarty: string): Boolean;
    procedure TejMetodyNieMonaWywoywa;
  end;

  TWeryfikatorKartKredytowych = class(TInterfacedObject, IWeryfikatorKartKredytowych)
    function CzyKartaJestWana(aNumerKarty: string): Boolean;
    procedure TejMetodyNieMonaWywoywa;
  end;

  EWyjtekWeryfikatoraKartKredytowych = class(Exception);

implementation

uses
  Dialogs;

function TWeryfikatorKartKredytowych.CzyKartaJestWana(aNumerKarty: string): Boolean;
begin
  // Ta metoda pozoruje odwoanie do serwera SOAP naliczajcego prowizj
  // 1 z od kadej transakcji

  // W tym przykadzie karta jest niewana, jeeli zawiera cyfr 7
  Result := Pos('7', aNumerKarty) <= 0;
  WriteLn('Zostae obciony prowizj 1 z');
  if not Result then
  begin
    raise EWyjtekWeryfikatoraKartKredytowych.Create('Niewana karta kredytowa! Transakcja odrzucona!');
  end;
end;

procedure TWeryfikatorKartKredytowych.TejMetodyNieMonaWywoywa;
begin
  // Ta operacja obciy Twoj firm kwot 500 z! Tej metody nie mona wywoywa!
end;

end.

